#!/bin/sh

check_seat_count() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    local db_host=`dtascfg "${DTASCFG_XML_FILE}" get db host`
    local db_username=`dtascfg "${DTASCFG_XML_FILE}" get db username`
    local db_password=`dtascfg "${DTASCFG_XML_FILE}" get db password`

    local stepName
    local sqlCommand
    local msg
    local ret

    local activateStatus
    stepName="GetActivateStatus"
    sqlCommand="select value from systemsettings where uniquekey = 'license.licenseType'"
    debug_print "${stepName}: sqlCommand='$sqlCommand'"
    msg=`psql --dbname dtasdb --username "${db_username}" --command "${sqlCommand}"`
    ret="${?}"
    if [ "${ret}" -ne 0 ]; then
        debug_print "${stepName}Fail: ret='$ret', msg='$msg'"
        warning "$msg"
        return 1
    fi
    activateStatus=`echo $msg | awk '{print $3}'`
    debug_print "${stepName}Pass: activateStatus='$activateStatus'"
    
    
    stepName="CheckActivateStatus"
    debug_print "${stepName}: activateStatus='$activateStatus'"
    if [ "${activateStatus}" -eq -1 ]; then
        debug_print "${stepName}Fail: Not activated."
        warning "${MASTER_PAGE_ADD_ESXI_INACTIVATE}"
        return 1
    fi
    
    
    local scCount
    stepName="GetScCount"
    sqlCommand="select count(sc_id) from tb_sc_info where sc_id != '0'"
    debug_print "${stepName}: sqlCommand='$sqlCommand'"
    msg=`psql --dbname dtasdb --username "${db_username}" --command "${sqlCommand}"`
    ret="${?}"
    if [ "${ret}" -ne 0 ]; then
        debug_print "${stepName}Fail: ret='$ret', msg='$msg'"
        warning "$msg"
        return 1
    fi
    scCount=`echo $msg | awk '{print $3}'`
    debug_print "${stepName}Pass: scCount='$scCount'"
    

    local seatCount
    stepName="GetSeatCount"
    sqlCommand="select value from tb_global_setting where key = 'configuration.license.seat_count'"
    debug_print "${stepName}: sqlCommand='$sqlCommand'"
    msg=`psql --dbname dtasdb --username "${db_username}" --command "${sqlCommand}"`
    ret="${?}"
    if [ "${ret}" -ne 0 ]; then
        debug_print "${stepName}Fail: ret='$ret', msg='$msg'"
        warning "$msg"
        return 1
    fi
    seatCount=`echo $msg | awk '{print $3}'`
    debug_print "${stepName}Pass: seatCount='$seatCount'"

    stepName="CheckSeatCount"
    debug_print "${stepName}: scCount='$scCount', seatCount='$seatCount'"
    if [ "${scCount}" -ge "${seatCount}" ]; then
        debug_print "${stepName}Fail: Maximum of SeatCount is reached"
        warning "`printf "${MASTER_PAGE_ADD_ESXI_EXCEED_SEAT_COUNT}" "${seatCount}"`"
		return 1
	fi
	debug_print "${stepName}Pass"
    
	return 0
}

master_page_add_esxi() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    check_seat_count
    if [ "${?}" -ne 0 ]; then
        return
    fi
    
    new_esxi_name=""
    new_esxi_host_ip=""
    new_esxi_username=""
    new_esxi_password=""
	new_esxi_ms_real_image_path=""
	new_esxi_sc_real_image_path=""
	new_esxi_sc_id=""
 
	add_esxi_pages_array="
		master_page_new_esxi_name
		master_page_new_esxi_info_conf
		master_page_new_esxi_ms_image_path_select
		master_page_new_esxi_sc_image_path_select
		master_page_new_esxi_save
		master_page_new_esxi_sync_ms
	"
	
    pages_roller "${add_esxi_pages_array}"
}